-- 通用建筑放置器 API

local UniversalPlacer = Class(function(self, inst)
    self.inst = inst
end)

function UniversalPlacer:MakePlacer(placer_name, bank, build, anim, snap_to_tile, snap_to_water, meter_fn)
    local function placer_fn()
        local inst = CreateEntity()
        
        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()
        
        -- 设置动画
        inst.AnimState:SetBank(bank)
        inst.AnimState:SetBuild(build)
        inst.AnimState:PlayAnimation(anim)
        
        -- 放置器视觉效果（半透明绿色）
        inst.AnimState:SetMultColour(0.2, 1, 0.2, 0.6)
        inst.AnimState:SetLightOverride(1)
        
        -- 标准放置器标签
        inst:AddTag("CLASSIFIED")
        inst:AddTag("NOCLICK")
        inst:AddTag("placer")
        
        inst.entity:SetPristine()
        
        if not TheWorld.ismastersim then
            return inst
        end
        
        inst.persists = false
        
        -- 添加放置器组件
        inst:AddComponent("placer")
        inst.components.placer.snap_to_tile = snap_to_tile or false
        inst.components.placer.snap_to_water = snap_to_water or false
        
        -- 如果有计量函数，设置它
        if meter_fn then
            inst.components.placer.meter = meter_fn
        end
        
        -- 设置建筑预览
        inst.components.placer:SetBuilder(nil, nil, nil, placer_name:gsub("_placer", ""))
        
        return inst
    end
    
    return Prefab(placer_name, placer_fn, {
        Asset("ANIM", "anim/"..build..".zip")
    })
end

-- 为特定建筑创建放置器的快捷函数
function UniversalPlacer:CreateStructurePlacer(structure_name, bank, build, anim, options)
    options = options or {}
    local placer_name = structure_name.."_placer"
    
    return self:MakePlacer(
        placer_name,
        bank or structure_name,
        build or structure_name,
        anim or "idle",
        options.snap_to_tile or false,
        options.snap_to_water or false,
        options.meter_fn
    )
end

return UniversalPlacer